// Import System requirements
import Vue from 'vue'
import Resource from 'vue-resource'
import VueRouter from 'vue-router'

import 'font-awesome/css/font-awesome.css'
import 'npm-font-source-sans-pro/source-sans-pro.css'

import routes from './routes'
import store from './store'

import ToggleButton from 'vue-js-toggle-button'
Vue.use(ToggleButton)

// Import Helpers for filters
import { domain, count, prettyDate, pluralize } from './filters'

// Import Views - Top level

import AppView from './components/App.vue'

// Import Install and register helper items
Vue.filter('count', count)
Vue.filter('domain', domain)
Vue.filter('prettyDate', prettyDate)
Vue.filter('pluralize', pluralize)

// Resource logic
Vue.use(Resource)

Vue.use(VueRouter)

Vue.http.interceptors.push((request, next) => {
  var headers = request.headers
  if (request.url !== 'api/login' && !headers.hasOwnProperty('Authorization')) {
    headers.map.Authorization = [store.state.token]
  }
  // console.log(headers)

  // continue to next interceptor without modifying the response
  next()
})

// Routing logic
var router = new VueRouter({
  routes: routes,
  mode: 'history',
  scrollBehavior: function (to, from, savedPosition) {
    return savedPosition || { x: 0, y: 0 }
  }
})

// Some middleware to help us ensure the user is authenticated.
router.beforeEach((to, from, next) => {
  // window.console.log('Transition', transition)
  if (to.auth && (to.router.app.$store.state.token === 'null')) {
    window.console.log('Not authenticated')
    next({
      path: '/login',
      query: { redirect: to.fullPath }
    })
  } else {
    next()
  }
})

// Start out app!
// eslint-disable-next-line no-new
new Vue({
  el: '#root',
  router: router,
  store: store,
  render: h => h(AppView)
})

// Check local storage to handle refreshes
if (window.localStorage) {
  if (store.state.user !== window.localStorage.getItem('user')) {
    store.dispatch('SET_USER', JSON.parse(window.localStorage.getItem('user')))
    store.dispatch('SET_TOKEN', window.localStorage.getItem('token'))
  }
}
