## 0.11.0 to 0.11.1

* ContactDB:
  * For compatibility with `jsonschema` version 3.2.0 available in Ubuntu 22.04, use JSON Schema Draft 07 instead of Draft 202012
  * Also validate organisations against the schema on update and deletion, not only creation.
* Release Documentation:
  Add missing steps for building and publishing to PyPI
  Further small improbements

## 0.10.1 to 0.11.0

* ContactDB and EventDB (Stats API):
  Added a database connection pooling and healthchecks to handle broken connections (#12, #18, #35).
* ContactDB: Use JSON Schema to validate all user inputs.
* Documentation:
  How to use the same authentication as the IntelMQ Manager (#40).
  How to run with hug (#23).
* Logs: Shorten the user representation of tracebacks to the useful parts (#38).
* Packaging: Use quilt.
* Tests: Add workflows to build the application, run the tests and check for print-statements.

## 0.10.0 to 0.10.1

 * ContactDB: Deleting organisations:
   The comparison of the organisation data stored in the database and the
   organisation data provided by the frontend now ignores empty 'expires'
   entries in all annotation types.

## 0.9.2 to 0.10.0

 * For the Audit log `intelmq-certbund-contact` version 0.9.5 is
   required for the `audit_log` database table.

## 0.9.1 to 0.9.2

 * Fixed compatibility of contactdb_api with PostsgreSQL >= 10.0.

## 0.9.0 to 0.9.1

 * Added authorization and session handling.
 * Added script to add users to the database.

## 0.8.1 to 0.9.0

 * Tickets and Events:
   * Send the timezone of the database via the /subqueries endpoint
     to allow the front end to display how values are interpreted in queries.

### Upgrade

 * Check that `SHOW timezone;` in the database gives a full timezone name,
   otherwise set it explicitly (find more details in `setup()` of
   `events_apt/events_api/serve.py).


## 0.8.0 to 0.8.1

 * Tickets and Events:
   * Indicate a client problem, if stats? endpoints are called with their main
     range selection parameters given more than once.
   * Small text improvement delete `Tag` from `Recipient Group Tag` subqueries.
 * config/apache-example:
   Add LogFormat to log time taken to serve the request to the LogFormat.


## 0.7.2 to 0.8.0

 * Tickets and Events:
   * Improve frontend usability by automatically searching for substrings
     in case of `_icontains` subqueries and by searching case-insensitive
     for strings in general.
   * Remove `_encl` subqueries as they are not needed.
   * Make subqueries similar (and equal in case of `intelmq-cb-mailgen`
     setups) between Tickets and Events.
 * Events: Add default subqueries for recipient email addresses.


## 0.7.1 to 0.7.2

 * Events: Fix endpoints that use queries with mailgen tables to also
   include events that have not been sent yet.


## 0.7.0 to 0.7.1

 * Events: Fix `./stats?` to count events only once in case of
   `intelmq-cb-mailgen` setups. Note that several entries can be returned
   with the corresponding `./search?` call. See usage hint for the reason.


## 0.6.4 to 0.7.0

 * Tickets:
   * Change default parameters for `./stats?` to include the full last day
     (based on what is the timezone of the database.)
   * Cleanup code: Remove unused and broken `?id=` ability, change
     `/?ticketnumber=` ability to return mailgen tables like `events/search`.

 * Events:
   * Change `./search?` to return the columns from `mailgen_directives` and
     `mailgen_sent` tables as JSON values for easier handling in clients.
   * Remove `./export?`, as too similar to `./search?` and assumed unused.
   * Fix subquery for "EventID" (broken since 0.6.4).
   * Fix support for hug v==2.2.0 in three endpoints.


## 0.6.3.1 to 0.6.4

 * Events:
   * Enhance endpoints `./search?`, `./export?` to allow searching by
     columns from joined `directives` and `sent` tables for symmetry with the
     tickets backend. Add example for searching for `recipient_group` in
     `aggregate_identifier`.

 * Contactdb:
   * Enhance endpoint `./annotation/search?tag=` to additionally search for
     email tags and return organisations with those email addresses.

### Upgrade
 * Optional: Add an index for "`recipient_group` to directives (2019-10)", see
   https://github.com/Intevation/intelmq-mailgen/blob/master/sql/updates.txt


## 0.6.3 to 0.6.3.1

 * Contactdb:
   * Fix handling of email tags, by returning the correct default tags.


## 0.6.2 to 0.6.3

 * Contactdb:
  * Disallows creating CIDRs or FQDNs with the same value in a single contact;
    only the first will be inserted. If this happens it shows in loglevel INFO.
 * Events:
   * Additional configuration parameter `database table` to set the
     table name of the events table. Default is `events`.
 * Contacts: Add handling of email tags.

### Upgrade
 *  Requirements: intelmq-certbund-contact>=0.9.4 on the db server.


## 0.6.1 to 0.6.2
 * Contactdb:
   * Adds GET and PUT endpoints for ./email/ and an additional endpoint GET
    /searchdisabledcontact to support the separate email_status table.

### Upgrade
 * Requirements: Check that we have postgresql v>=9.5.


## 0.6.0 to 0.6.1

 * Checkticket:
   * Adds optional `limit` parameter to endpoint `./getEventsForTicket`.
   * Changes `getEventIDsForTicket` to returned a sorted list, to make
     the query result consistent for the same parameter.


## 0.5.3 to 0.6.0

 * Contactdb:
   * Fixes search by email address so it filters out duplicates.
   * Adds `tools/import_manual_contacts.py` to import manual contacts
     from a .csv file via TLS.
   * Adds sorting to some attribute lists when serving an org. Attributes
     sorted are contacts, asns, networks, fqdns, national_certs and tags.


## 0.5.2 to 0.5.3

 * Events: Changes /search endpoint to return complete events (similar to
     checkticket's /getEvents)
 * Events: Enhances subqueries:
   * New subqueries can be added in the config file, see example configuration.
   * The given parameter can be used multiple times in an SQL query,
     for example: `("source.ip" = '%s' OR "destination.ip" = '%s')`

### Upgrade
 * Configuration: (optional) Add the example subquery `all_ips` to the
     eventsdb config file to get one more useful query.


## 0.5.1 to 0.5.2

 * Contactdb: Fixes annotation/search for organisation\_annotations.


## 0.5.0 to 0.5.1

 * Contactdb: Adds search for annotations by tag-name.
 * Contactdb: Allows to configure the list of common "tags".
 * Contactdb: Changes email search to be case-insensitive.

### Upgrade
 * Configuration: (optional) Add "common\_tags" to the contactdb config file,
     otherwise the default ones may be exposed to users by the frontend.


## 0.4.3.dev0 to 0.5.0
 * Contactdb: Allows tracking of db changes by user.
 * Contactdb: Adds example script for importing a manual whitelist.
 * Technical: Module called "intelmq-fody-backend" now
 * Technical: Compatible with psycopg2 coming with Ubuntu 16.04LTS now.

### Upgrade
 * To enable tracking of db changes by user follow instructions in README.md.
 * Technical: Must make sure that calling code uses the new module name.
